/***************************************************************************
 *   Copyright (C) 2006 by Emanuel Wegh                                    *
 *   maan@ddsw.nl                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <QtGui>

#include "bulb.h"

Bulb::Bulb(QWidget *parent) : QWidget(parent)
{
	this->setMinimumSize(25, 25);
	
	redBulb();
}

void Bulb::redBulb()
{
	bulbColor = 1;	// Default color = Red
	
	repaint();
}

void Bulb::greenBulb()
{
	bulbColor = 2;
	
	repaint();
}

void Bulb::paintEvent(QPaintEvent *)
{
	QPainter painter(this);
	QRadialGradient gradient(13, 13, 10, 9, 9);
	
	painter.setRenderHint(QPainter::Antialiasing);
	
	gradient.setColorAt(0.2, Qt::white);
	if (bulbColor == 1)
		gradient.setColorAt(0.8, Qt::red);
	else
		gradient.setColorAt(0.8, Qt::green);
	gradient.setColorAt(1, Qt::black);
	
	painter.setBrush(gradient);
	painter.drawEllipse(3, 3, 20, 20);
}
