/***************************************************************************
 *   Copyright (C) 2006 by Emanuel Wegh                                    *
 *   maan@ddsw.nl                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <QtGui>

#include "camerawidget.h"

CameraWidget::CameraWidget(QWidget *parent) : QWidget(parent)
{
	// init
	image = new QImage(WIDTH, HEIGHT, QImage::Format_RGB32);
	
	// Set widget size
	resize(WIDTH, HEIGHT);
	setMinimumSize(WIDTH, HEIGHT);
	show();
}

CameraWidget::~CameraWidget()
{
	delete(image);
}

void CameraWidget::setImage(const QByteArray *imageBuffer)
{
	//int x, y, i;
	/*QColor colorPixel;
	
	// convert QByteArray to QImage
	i = 0;
	for(y = 0; y < HEIGHT; y++)
		for(x = 0; x < WIDTH; x++)
		{
			colorPixel.setRgb(	(quint8)imageBuffer->at(i), 
								(quint8)imageBuffer->at(i + 1), 
								(quint8)imageBuffer->at(i + 2));
			image->setPixel(x, y, colorPixel.rgb());
			i += 3;
		}
	*/
	
	// load jpeg image
	image->loadFromData(*imageBuffer, "JPG");
	
	update();		// update widget with new image
}

void CameraWidget::paintEvent(QPaintEvent *)
{
	QPainter paint(this);
	
	paint.drawImage(0, 0, *image);
}
