/***************************************************************************
 *   Copyright (C) 2006 by Emanuel Wegh                                    *
 *   maan@ddsw.nl                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <QtGui>

#include "qsliderarrow.h"

QSliderArrow::QSliderArrow(QWidget *parent) : QSlider(parent)
{
}

QSliderArrow::QSliderArrow(Qt::Orientation orientation, QWidget *parent) : QSlider(orientation, parent)
{
}


void QSliderArrow::paintEvent(QPaintEvent *event)
{
	static const int arrowRadius = 10, arrowWidth = arrowRadius * 2, arrowBaseRadius = 4;
	
	// Create arrow
	QPoint arrow[7] =
	{
		QPoint(arrowRadius, 0),
		QPoint(arrowWidth, arrowWidth),
		QPoint(arrowRadius + arrowBaseRadius, arrowWidth),
		QPoint(arrowRadius + arrowBaseRadius, height() / 3),
		QPoint(arrowRadius - arrowBaseRadius, height() / 3),
		QPoint(arrowRadius - arrowBaseRadius, arrowWidth),
		QPoint(0, arrowWidth)
	};
	
	QPen pen(Qt::gray);
	pen.setWidth(2);
	
	
	QPainter *painter = new QPainter(this);

	painter->setPen(pen);
	painter->setBrush(QColor(0, 0, 100, 100));

	if (orientation() == Qt::Horizontal)
	{
		// paint center line
		painter->drawLine(width() / 2, 0, width() / 2, height());
		
		// no arrow !!!!
		
		/*
		painter->setRenderHint(QPainter::Antialiasing);
		painter->translate(0, height() - 1);
		painter->rotate(-90);
		painter->drawConvexPolygon(arrow, 7);
		painter->rotate(90);
		painter->translate(width() - 1, - height() + 1);
		painter->rotate(90);
		painter->drawConvexPolygon(arrow, 7);
		*/
	}
	else	// Qt::Vertical
	{
		// center arrow
		QPoint offset(width() / 2 - arrowRadius, 10);
		for(int i = 0; i < 7; i++)
			arrow[i] += offset;
		
		// paint center line
		painter->drawLine(0, height() / 2, width(), height() / 2);
		
		// paint arrows
		painter->setRenderHint(QPainter::Antialiasing);
		painter->drawConvexPolygon(arrow, 7);
		painter->translate(width() - 1, height() - 1);
		painter->rotate(180);
		painter->drawConvexPolygon(arrow, 7);
	}
	
	delete(painter);

	// Paint QSlider
	QSlider::paintEvent(event);
}
