/***************************************************************************
 *   Copyright (C) 2006 by Emanuel Wegh                                    *
 *   maan@ddsw.nl                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ROBOTGUI_H
#define ROBOTGUI_H

#define ROBOT_INFO "Robot Client version 0.20"

#include <QDialog>

#include "rsocket.h"
#include "bulb.h"


class QSliderArrow;
class QPushButton;
class QTextEdit;
class QLineEdit;
class CameraWidget;

class RobotGui : public QDialog
{
	Q_OBJECT

public:
	RobotGui(QWidget *parent = 0);

private slots:
	void slowBreak();
	void straightAhead();
	void steeringSpeed(int state);
	void connectToHost();
	void connectionEstablished();
	void connectionError(QAbstractSocket::SocketError socketError);
	void info();

private:
	QSliderArrow	*horizontalSlider;
	QSliderArrow	*verticalSlider;
	QTextEdit		*textBox;
	QLineEdit		*hostName; 
	Bulb			*connectBulb;   
	RSocket			*rSocket;
	CameraWidget	*cameraWidget;

};

#endif
