 /***************************************************************************
 *   Copyright (C) 2006 by Emanuel Wegh                                    *
 *   maan@ddsw.nl                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "jpegcompress.h"

#include <stdio.h>
#include <jpeglib.h>
#include <setjmp.h>

JpegCompress::JpegCompress(int width, int height)
{
	// init
	rowWidth = 3 * width;		// row width in bytes
	
	// init compression object
	cinfo.err = jpeg_std_error(&jerr);
	jpeg_create_compress(&cinfo);
	
	cinfo.image_width = width;
	cinfo.image_height = height;
	cinfo.input_components = 3;
	cinfo.in_color_space = JCS_RGB;
	cinfo.dct_method = JDCT_IFAST;
	
	// set default compression parameters
	jpeg_set_defaults(&cinfo);
	
	// JPEG quality: no effect on CPU usage
	//jpeg_set_quality(&cinfo, 80, false);
}

JpegCompress::~JpegCompress()
{
	jpeg_destroy_compress(&cinfo);
}

void JpegCompress::writeJpeg(unsigned char *imageBuffer)
{
	FILE *outfile;
	
	// open file
	if ((outfile = fopen("/tmp/webcam.jpeg", "wb")) == NULL)
	{
    	fprintf(stderr, "Can't open file\n");
    	return;
 	}
	jpeg_stdio_dest(&cinfo, outfile);

		
	// start compression
	jpeg_start_compress(&cinfo, TRUE);
	
	// compress each row
	while(cinfo.next_scanline < cinfo.image_height)
	{
		row_pointer[0] = imageBuffer + cinfo.next_scanline * rowWidth;
    	jpeg_write_scanlines(&cinfo, row_pointer, 1);
	}
	
	// finish compression
	jpeg_finish_compress(&cinfo);
	
	fclose(outfile);
}
