/***************************************************************************
 *   Copyright (C) 2006 by Emanuel Wegh                                    *
 *   maan@ddsw.nl                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#ifndef ROBOTCONTROL_H
#define ROBOTCONTROL_H

#include <QObject>

#include "TeleoEasy.h"
#include "TeleoIntroPwm.h"
#include "TeleoIntroDout.h"
#include "TeleoIntroDin.h"
#include "TeleoIntroAin.h"
#include "TeleoMotor.h"


const int   MIN_SPEED = -100;
const int   MAX_SPEED = 100;
const int   MIN_STEERING = -100;
const int   MAX_STEERING = 100;
const int   SPEED_STEP_SIZE = 4;	// must be dividable by 2
const float MAX_LOG_SPEED = 1000;

const char teleoErrorText[20][34] =
{
	"All OK",
	"Data missing",
	"Logic Error",
	"Unknown",
	"Truncated",
	"Module wasn't bound",
	"Address wasn't correct",
	"Feature is not implemented",
	"IO Error",
	"Null pointer encountered",
	"Error Opening",
	"Error Reading",
	"Error Writing",
	"Error Closing",
	"Type was unknown",
	"Conversion error",
	"Allocation error",
	"Entity was not found",
	"Device number was illegal",
	"Insufficient space for operation"
};

class QTimer;

class RobotControl : public QObject
{
	Q_OBJECT
	
public:
	RobotControl(QObject *parent = 0);
	~RobotControl();

	bool startTeleo();
	void setSpeed(const int speed);
	void setSteering(const int steering);
	void stopMotors();
	void turnOnConnectLed();
	void turnOffConnectLed();
	void turnOnLowPowerLed();
	void turnOffLowPowerLed();
	void switchToExtPower();
	void switchToAccuPower();
	bool getExtPowerStatus();

private:
	TeleoError teleoError, teleoError1, teleoError2;
	TMotor *motorLeft;
	TMotor *motorRight;
	//TIntroPwm *light;
	TIntroDout *lowPowerLed, *connectLed;
	TIntroPwm *extPowerSwitch;
	TIntroDin *extPower;
	TIntroAin *pcV, *motorV;
	int     speed, newSpeed, steering, newSteering;
	bool	externalPower;
	float	maxPowerDutyValue;
	QTimer *timer, *extPowerTimer;
	static  RobotControl *ptr;
	
	void  updateMotorSpeed();
	void  startChangingMotorSpeed();
	void  checkMaxValue(int &speed, const int min, const int max);
	float logSpeed(const int speed);
	void  teleoErrorHandler(TeleoError error, char *errorText);
	void  wait (int seconds);
	
	TeleoError checkPCVoltage(TIntroAin *tma, short int value);
	TeleoError extPowerUpdate(TIntroDin *tmdin, bool power);
	static TeleoError extPowerUpdateWrapper(TIntroDin *tmdin, bool power);
	static TeleoError checkPCVoltageWrapper(TIntroAin *tma, short int value);
	static TeleoError checkTeleoVoltage(TIntroAin *tma, short int value);

private slots:
	void changeMotorSpeedSlowly();
	void checkExtPowerStatus();

};

#endif
